#include "enyx/cores_c/memory_tester/memory_tester.h"
ENYX_CORES_NAMESPACE_BEGIN

namespace memory_tester {

inline
memory_tester::memory_tester(::enyx_memory_tester * handle)
    :memtest_(handle)
{
    if (memtest_ == nullptr)
        throw std::runtime_error{
            "Cannot initialize memory tester subsystem from NULL handle"};
}

inline
memory_tester::memory_tester(hw::core & core)
    :memtest_(::enyx_memory_tester_create(core.handle()))
{
    if (memtest_ == nullptr)
        throw std::system_error{errno, std::generic_category(),
            "Failed to create memory tester subsystem"};
}

inline result<void>
memory_tester::set_parameters(parameters const & params)
{
    if (::enyx_memory_tester_set_parameters(handle(), &params) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<void>
memory_tester::start()
{
    if (::enyx_memory_tester_start(handle()) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<void>
memory_tester::stop()
{
    if (::enyx_memory_tester_stop(handle()) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<void>
memory_tester::clear_error()
{
    if (::enyx_memory_tester_clear_error(handle()) < 0)
        return std::error_code{errno, std::generic_category()};

    return {};
}

inline result<bool>
memory_tester::is_done() const
{
    bool done;
    if (::enyx_memory_tester_is_done(handle(), &done) < 0)
        return std::error_code{errno, std::generic_category()};

    return done;
}

inline result<bool>
memory_tester::has_failed() const
{
    bool failed;
    if (::enyx_memory_tester_has_failed(handle(), &failed) < 0)
        return std::error_code{errno, std::generic_category()};

    return failed;
}

inline result<std::uint8_t>
memory_tester::get_last_fail() const
{
    std::uint8_t last_fail;
    if (::enyx_memory_tester_get_last_fail(handle(), &last_fail) < 0)
        return std::error_code{errno, std::generic_category()};

    return last_fail;
}

inline result<std::size_t>
memory_tester::get_fail_count() const
{
    auto fail_count = ::enyx_memory_tester_get_fail_count(handle());
    if (fail_count < 0)
        return std::error_code{errno, std::generic_category()};

    return fail_count;
}

inline ::enyx_memory_tester const *
memory_tester::handle() const
{
    return memtest_.get();
}

inline ::enyx_memory_tester *
memory_tester::handle()
{
    return memtest_.get();
}

inline result<std::vector<memory_tester>>
enumerate(hw::core const & root)
{
    auto count = ::enyx_memory_tester_enumerate(root.handle(), NULL, 0);
    if (count < 0)
        return std::error_code{errno, std::generic_category()};

    if (count == 0)
        return {};

    std::vector<::enyx_memory_tester *> memtesters_c(count);
    if (::enyx_memory_tester_enumerate(root.handle(),
                                       memtesters_c.data(),
                                       memtesters_c.size()) < 0)
        return std::error_code{errno, std::generic_category()};

    std::vector<memory_tester> memtesters;
    for (auto memtester_c: memtesters_c)
        memtesters.push_back(memtester_c);

    return memtesters;
}

}

ENYX_CORES_NAMESPACE_END
