ENYX_CORES_NAMESPACE_BEGIN

namespace eth_if {

inline
eth_if::eth_if(hw::core const & core)
    : eth_if_core_(core)
    , eth_if_c_(::enyx_eth_if_create(eth_if_core_.handle()))
{
    if (! eth_if_c_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create eth_if object"};
}

inline result<int>
eth_if::get_supported_data_rates() const noexcept
{
    auto res = ::enyx_eth_if_get_supported_data_rates(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};

    return res;
}

inline result<bool>
eth_if::get_i2c_support() const noexcept
{
    auto res = ::enyx_eth_if_get_i2c_support(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};

    return res;
}

inline result<uint8_t>
eth_if::get_i2c_controller_id() const noexcept
{
    uint8_t value;
    if (::enyx_eth_if_get_i2c_controller_id(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::uint32_t>
eth_if::get_clock_frequency() const noexcept
{
    std::uint32_t value;
    if (::enyx_eth_if_get_clock_frequency(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<uint32_t>
eth_if::get_data_width() const noexcept
{
    uint32_t value;
    if (::enyx_eth_if_get_data_width(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<uint8_t>
eth_if::get_netif_id() const noexcept
{
    uint8_t value;
    if (::enyx_eth_if_get_netif_id(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<bool>
eth_if::is_netif_enabled() const noexcept
{
    auto res = ::enyx_eth_if_is_netif_enabled(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};

    return res;
}

inline result<uint32_t>
eth_if::get_physical_id() const noexcept
{
    uint32_t value;
    if (::enyx_eth_if_get_physical_id(handle(), &value) < 0)
        return std::error_code{errno, std::generic_category()};

    return value;
}

inline result<std::string>
eth_if::get_physical_name() const noexcept
{
    char buffer[128];
    if (::enyx_eth_if_get_physical_name(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
eth_if::get_usage_name() const noexcept
{
    char buffer[128];
    if (::enyx_eth_if_get_usage_name(handle(), buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
eth_if::get_i2c_configuration() const noexcept
{
    char buffer[128];
    if (::enyx_eth_if_get_i2c_configuration(handle(),
                                            buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline result<std::string>
eth_if::get_raw_configuration() const noexcept
{
    char buffer[128];
    if (::enyx_eth_if_get_raw_configuration(handle(),
                                            buffer, sizeof(buffer)) < 0)
        return std::error_code{errno, std::generic_category()};

    return buffer;
}

inline ::enyx_eth_if *
eth_if::handle() noexcept
{
    return eth_if_c_.get();
}

inline ::enyx_eth_if const *
eth_if::handle() const noexcept
{
    return eth_if_c_.get();
}

} /* namespace eth_if */

ENYX_CORES_NAMESPACE_END
