"""Misc utilities for manipulating object trees"""

from typing import List, Tuple, Type, Union


def chain_variables(variables):
    """Chain variables and sub variables"""
    for var in variables:
        yield var
        if hasattr(var, 'variables'):
            yield from var.variables


def isregisterinstance(instance: object, classinfo: Union[Type, Tuple[Type]]):
    """Test if an object contains a register of a specific type or tuple
    of types.
    """
    return hasattr(instance, 'register') and isinstance(instance.register,
                                                        classinfo)


def filter_subtree(subtree: List[object], classinfo: Union[Type, Tuple[Type]],
                   invert: bool = False):
    """Filter elements of an iterable that contain registers of a
    specific type or list of types."""
    yield from filter(lambda o: isregisterinstance(o, classinfo) != invert,
                      subtree)
