#pragma once

/**
 * @file
 *
 * This file contains a interprocess mutex implementation, used to protect
 * hardware accesses between multiple process invocations of enyx-hw primitives.
 */

#include <enyx/hw_c/symbol_visibility.h>

/// The enyx_hw_shared_mutex type representing an interprocess shared mutex.
typedef struct enyx_hw_shared_mutex enyx_hw_shared_mutex;

/**
 *  Create a shared mutex between process.
 *
 *  @param format The printf style format used to name the lock.
 *  @return The created lock or NULL if something went wrong.
 */
ENYX_HW_C_SYMBOL_VISIBILITY enyx_hw_shared_mutex *
enyx_hw_shared_mutex_create(const char * format, ...);

/**
 *  Destroy a shared mutex.
 *
 *  @param s The lock handle to destroy.
 */
ENYX_HW_C_SYMBOL_VISIBILITY void
enyx_hw_shared_mutex_destroy(enyx_hw_shared_mutex * s);

/**
 *  Acquire a lock.
 *
 *  @param s The lock to use.
 *  @return 0 on success, -1 otherwise.
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_shared_mutex_lock(enyx_hw_shared_mutex * s);

/**
 *  Try to acquire a lock.
 *
 *  @param s The lock to use.
 *  @return 0 on success, -1 otherwise.
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_shared_mutex_trylock(enyx_hw_shared_mutex * s);

/**
 *  Release a lock.
 *
 *  @param s The lock to use.
 *  @return 0 on success, -1 otherwise.
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_shared_mutex_unlock(enyx_hw_shared_mutex * s);
