#pragma once

#include <stdlib.h>
#include <stdint.h>

#include <enyx/hw_c/symbol_visibility.h>

/**
 * Opaque class representing properties.
 *
 * This class can be used as a filter to find specific device(s)
 * or as a source of information on a discovered device(s).
 *
 * @since 5.1.0
 */
typedef struct enyx_hw_properties enyx_hw_properties;

/**
 * Test if two properties object are equals.
 *
 * @param a First operand
 * @param b Second operand
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_cmp(enyx_hw_properties const * a, enyx_hw_properties const * b);

/**
 * Retrieve the UID property
 *
 * @param prop The properties object to query
 * @param buffer The buffer to fill with the name
 * @param capacity The buffer capacity
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 *
 * @since 5.1.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_get_uid(enyx_hw_properties const * prop, char * buffer, size_t capacity);

/**
 * Retrieve the index property
 *
 * @param prop The properties object to query
 * @param index The integer to fill with the index
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 *
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_get_index(enyx_hw_properties const * prop, uint32_t * index);

/**
 * Retrieve the name property
 *
 * @param prop The properties object to query
 * @param buffer The buffer to fill with the name
 * @param capacity The buffer capacity
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 *
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_get_name(enyx_hw_properties const * prop, char * buffer, size_t capacity);

/**
 * Retrieve the mtu property
 *
 * @param prop The properties object to query
 * @param mtu The integer to fill with the mtu
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 *
 * @since 5.0.0
 * @deprecated replaced by a2c/c2a stream get_mtu methods
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_get_mtu(enyx_hw_properties const * prop, uint32_t * mtu)
    ENYX_HW_C_DEPRECATED("replaced by a2c/c2a stream get_mtu methods");

/**
 * Retrieve the size property
 *
 * @param prop The properties object to query
 * @param size The integer to fill with the size
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 *
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_get_size(enyx_hw_properties const * prop, size_t * size)
    ENYX_HW_C_DEPRECATED("replaced by a2c/c2a stream get_size methods");

/**
 * Available accelerator drivers
 *
 * @since 5.9.5
 */
enum {
    ENYX_HW_HFP_DRIVER,
    ENYX_HW_MOCK_DRIVER
};

/**
 * Retrieve the driver property
 *
 * @param prop The properties object to query
 * @param driver The integer to fill with the driver
 * @return 0 on success, -1 on error (@b errno is set accordingly)
 *
 * @since 5.9.5
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_prop_get_driver(enyx_hw_properties const * prop, int * driver);
