#pragma once

#include <stdint.h>
#include <sys/types.h>
#include <enyx/hw_c/symbol_visibility.h>

/**
 * Product version type
 */
typedef struct {
    /// version major
    uint16_t major;
    /// version minor
    uint16_t minor;
    /// version patch
    uint16_t patch;
} enyx_hw_product_version;

/**
 * Parse the @p product version from a @p string.
 *
 * @param string The string to parse
 * @param[out] version The version to fill
 * @return @b 0 on success, @b -1 on failure (with @b errno set accordingly)
 */
ENYX_HW_C_SYMBOL_VISIBILITY int
enyx_hw_product_version_parse(char const * string,
                              enyx_hw_product_version * version);

/**
 * Print the @p version into a @p buffer of @p buffer_capacity.
 *
 * @note If this function is called with an NULL @p buffer and 0 as @p
 * buffer_capacity, this function will return the size necessary to print @p
 * version (excluding the terminating null byte).
 *
 * @param version The version to print
 * @param[out] buffer The buffer to print to
 * @param buffer_capacity The size of @p buffer
 * @return The length of @p version as string on success (said length may be
 * bigger than @p buffer_capacity), -1 on error (with @b errno set
 * accordingly)
 */
ENYX_HW_C_SYMBOL_VISIBILITY ssize_t
enyx_hw_product_version_print(enyx_hw_product_version const * version,
                              char * buffer,
                              size_t buffer_capacity);
