ENYX_HW_NAMESPACE_BEGIN

inline
result<void>
write(core const& c, register_description const& r, std::uint64_t value) noexcept
{
    if (enyx_hw_write(c.handle(), &r, value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline
result<std::uint64_t>
read(core const& c, register_description const& r) noexcept
{
    uint64_t result;
    if (enyx_hw_read(c.handle(), &r, &result) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {result};
}

inline
result<std::string>
read_string(core const& c,
            register_description const& index,
            register_description const& value) noexcept
{
    char out[1024];
    if (enyx_hw_read_str(c.handle(), &index, &value, out, 1024) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {std::string{out}};
}

inline
result<void>
poll_until_equal_to(core const& c,
                    register_description const& r,
                    std::uint64_t expected,
                    std::chrono::milliseconds timeout_ms) noexcept
{
    if (enyx_hw_poll_until_equal_to(c.handle(), &r, expected, timeout_ms.count()) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline
result<void>
change_page(core const & core,
            register_description const & page_count,
            register_description const & page_id,
            register_description const & page_ready,
            std::uint64_t new_page_id)
{
    if (enyx_hw_change_page(core.handle(), &page_count, &page_id, &page_ready,
                            new_page_id) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline
result<void>
change_page(core const & core,
            register_description const & page_count,
            register_description const & page_id,
            std::uint64_t new_page_id)
{
    if (enyx_hw_change_page(core.handle(), &page_count, &page_id, nullptr,
                            new_page_id) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

ENYX_HW_NAMESPACE_END
