ENYX_HW_NAMESPACE_BEGIN

inline
properties::properties(enyx_hw_properties const *props)
    : properties_(props)
{};

template<typename Property>
inline result<typename
Property::value_type> properties::get() const noexcept
{
    return Property::get(properties_);
}

inline enyx_hw_properties const *
properties::handle() const noexcept
{
    return properties_;
}

inline
filter::filter(enyx_hw_filter *f)
    : filter_(f, &enyx_hw_filter_destroy)
{};

inline
filter::filter()
    : filter(enyx_hw_filter_create())
{}

template<typename ...Properties>
inline
filter::filter(Properties... props)
    : filter()
{
    set(std::forward<Properties>(props)...);
}

template<typename Property>
inline result<typename Property::value_type>
filter::get() const noexcept
{
    return Property::get(filter_.get());
}

template<typename Property>
inline result<void>
filter::set(typename Property::value_type const &value) noexcept
{
    return Property::set(filter_.get(), value);
}

template<typename Property>
inline result<void>
filter::set(Property const &property) noexcept
{
    return Property::set(filter_.get(), property.value);
}

template<typename Property, typename... Properties>
inline result<void>
filter::set(Property const &property, Properties... properties) noexcept
{
    auto ret = set(property);
    if (!ret)
        return ret;
    return set(std::forward<Properties>(properties)...);
}

inline enyx_hw_filter *
filter::handle() noexcept
{
    return filter_.get();
}

inline enyx_hw_filter const *
filter::handle() const noexcept
{
    return filter_.get();
}

ENYX_HW_NAMESPACE_END
