/**
 *  @file
 *
 *  This file contains the enyx::hw namespace definition
 *
 *  @namespace enyx
 *
 *  Contains the enyx company C++ code.
 *
 *  @namespace enyx::hw
 *
 *  Contains the hw library classes and functions.
 */
#pragma once

#include <enyx/hw_c/version.h>

/// @cond
#define _ENYX_HW_NAMESPACE_VERSION1(prefix, version) \
    prefix ## version
#define _ENYX_HW_NAMESPACE_VERSION2(version) \
    _ENYX_HW_NAMESPACE_VERSION1(v, version)
/// @endcond

/// Begin the hw namespace.
#define ENYX_HW_NAMESPACE_BEGIN \
    namespace enyx { \
    namespace hw { \
    inline namespace _ENYX_HW_NAMESPACE_VERSION2(ENYX_HW_C_VERSION_MAJOR) {

/// End the hw namespace.
#define ENYX_HW_NAMESPACE_END \
    } } }
