#pragma once

#include <enyx/hw/mocking/mock.hpp>

ENYX_HW_NAMESPACE_BEGIN
namespace mocking {

/**
 * This class is used to provided RAII-style mock installation
 */
class installer final
{
public:
    /**
     *  Install the @p new_mock
     */
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
    explicit
    installer(mock const& new_mock);
#pragma GCC diagnostic pop

    /**
     *  Install the @p new_mock
     */
    explicit
    installer(enyx_hw_mock const& new_mock);

    /**
     * Remove the installed mock and restore the previous one
     */
    ~installer(void);

private:
    enyx_hw_mock const* previous_mock_;
};

} /* namespace mocking */
ENYX_HW_NAMESPACE_END

#include <enyx/hw/mocking/installer.ipp>
