ENYX_HW_NAMESPACE_BEGIN

namespace mocking {
inline
a2c_stream_interface::a2c_stream_interface()
    : handle_(new ::enyx_hwm_a2c_stream_interface())
{
    handle_->context = this;

    handle_->on_create = [] (void * context) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->on_create)
            return 0;

        return thiz->on_create();
    };

    handle_->on_destroy = [] (void * context) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->on_destroy)
            return;
        thiz->on_destroy();
    };

    handle_->get_uid = [] (void * context, char * buffer, size_t capacity) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_uid) {
            errno = ENOSYS;
            return -1;
        }

        std::strncpy(buffer, thiz->get_uid().c_str(), capacity);
        return 0;
    };

    handle_->get_name = [] (void * context, char * buffer, size_t capacity) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_name) {
            errno = ENOSYS;
            return -1;
        }

        std::strncpy(buffer, thiz->get_name().c_str(), capacity);
        return 0;
    };

    handle_->get_mtu = [] (void * context, uint32_t * mtu) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_mtu) {
            errno = ENOSYS;
            return -1;
        }

        *mtu = thiz->get_mtu();
        return 0;
    };

    handle_->get_size = [] (void * context) -> ssize_t{
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_size) {
            errno = ENOSYS;
            return -1;
        }

        return thiz->get_size();
    };

    handle_->poll_once = [] (void * context,
                             enyx_hw_a2c_stream_handler on_data,
                             void * opaque) -> size_t {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->poll_once)
            return 0;

        return thiz->poll_once(on_data, opaque);
    };

    handle_->get_packet_count = [] (void * context, uint32_t * packet_count) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_packet_count) {
            errno = ENOSYS;
            return -1;
        }
        
        *packet_count = thiz->get_packet_count();
        return 0;
    };

    handle_->get_backpressure = [] (void * context, uint32_t * backpressure) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_backpressure) {
            errno = ENOSYS;
            return -1;
        }
        
        *backpressure = thiz->get_backpressure();
        return 0;
    };

    handle_->get_fifo_errors = [] (void * context, uint32_t * fifo_errors) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_fifo_errors) {
            errno = ENOSYS;
            return -1;
        }
        
        *fifo_errors = thiz->get_fifo_errors();
        return 0;
    };

    handle_->get_truncated_count = [] (void * context, uint32_t * truncated_count) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_truncated_count) {
            errno = ENOSYS;
            return -1;
        }

        *truncated_count = thiz->get_truncated_count();
        return 0;
    };

    handle_->get_errors = [] (void * context, uint32_t * errors) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_errors) {
            errno = ENOSYS;
            return -1;
        }
        
        *errors = thiz->get_errors();
        return 0;
    };

    handle_->get_usage = [] (void * context, uint32_t * usage) {
        auto thiz = reinterpret_cast<a2c_stream_interface*>(context);

        if (! thiz->get_usage) {
            errno = ENOSYS;
            return -1;
        }
        
        *usage = thiz->get_usage();
        return 0;
    };
}

inline ::enyx_hwm_a2c_stream_interface *
a2c_stream_interface::handle() noexcept
{
    return handle_.get();
}

inline ::enyx_hwm_a2c_stream_interface const *
a2c_stream_interface::handle() const noexcept
{
    return handle_.get();
}

} /* namespace mocking */

ENYX_HW_NAMESPACE_END
