ENYX_HW_NAMESPACE_BEGIN

inline
mmio::mmio(mmio_descriptor const & descriptor)
    : accelerator_(descriptor.get_accelerator()),
      mmio_(enyx_hw_mmio_create(descriptor.handle()), &enyx_hw_mmio_destroy)
{
    if (mmio_ == nullptr)
        throw std::system_error{errno, std::generic_category()};
}

inline mmio_descriptor
mmio::get_descriptor() const
{
    return {accelerator_, enyx_hw_mmio_get_descriptor(handle())};
}

inline result<void>
mmio::write_8(mmio::addr_type addr, std::uint8_t value)
{
    if (enyx_hw_mmio_write_8(handle(), addr, value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<void>
mmio::write_16(mmio::addr_type addr, std::uint16_t value)
{
    if (enyx_hw_mmio_write_16(handle(), addr, value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<void>
mmio::write_32(mmio::addr_type addr, std::uint32_t value)
{
    if (enyx_hw_mmio_write_32(handle(), addr, value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<void>
mmio::write_64(mmio::addr_type addr, std::uint64_t value)
{
    if (enyx_hw_mmio_write_64(handle(), addr, value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {};
}

inline result<std::uint8_t>
mmio::read_8(mmio::addr_type addr)
{
    std::uint8_t value;
    if (enyx_hw_mmio_read_8(handle(), addr, &value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {value};
}

inline result<std::uint16_t>
mmio::read_16(mmio::addr_type addr)
{
    std::uint16_t value;
    if (enyx_hw_mmio_read_16(handle(), addr, &value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {value};
}

inline result<std::uint32_t>
mmio::read_32(mmio::addr_type addr)
{
    std::uint32_t value;
    if (enyx_hw_mmio_read_32(handle(), addr, &value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {value};
}

inline result<std::uint64_t>
mmio::read_64(mmio::addr_type addr)
{
    std::uint64_t value;
    if (enyx_hw_mmio_read_64(handle(), addr, &value) != 0)
        return {std::error_code{errno, std::generic_category()}};
    return {value};
}

inline enyx_hw_mmio *
mmio::handle() noexcept
{
    return mmio_.get();
}

inline enyx_hw_mmio const *
mmio::handle() const noexcept
{
    return mmio_.get();
}

ENYX_HW_NAMESPACE_END
