ENYX_HW_NAMESPACE_BEGIN

inline accelerator::accelerator(accelerator_descriptor const & descriptor)
    : descriptor_(descriptor),
      accelerator_(enyx_hw_accelerator_get(descriptor.handle()),
                   &enyx_hw_accelerator_put)
{
    if (accelerator_ == nullptr)
        throw std::system_error{errno, std::generic_category()};
}

inline accelerator_descriptor
accelerator::get_descriptor() const noexcept
{
    return descriptor_;
}

inline std::vector<mmio_descriptor>
accelerator::enumerate_mmios() const noexcept
{
    auto mmio_count = enyx_hw_accelerator_count_mmios(accelerator_.get());
    std::vector<enyx_hw_mmio_descriptor const *> c_descriptors(mmio_count);
    int ret = enyx_hw_accelerator_enumerate_all_mmios(accelerator_.get(),
                                                      c_descriptors.data(),
                                                      c_descriptors.size());
    if (ret < 0)
        return {};
    std::vector<mmio_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        vec.emplace_back(*this, c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline std::vector<mmio_descriptor>
accelerator::enumerate_mmios(filter const & filter) const noexcept
{
    auto mmio_max = enyx_hw_accelerator_count_mmios(accelerator_.get());
    std::vector<enyx_hw_mmio_descriptor const *> c_descriptors(mmio_max);
    auto ret = enyx_hw_accelerator_enumerate_mmios(accelerator_.get(),
                                                   filter.handle(),
                                                   c_descriptors.data(),
                                                   c_descriptors.size());
    if (ret < 0)
        return {};

    std::vector<mmio_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        if (c_descriptor == nullptr)
            break;
        vec.emplace_back(*this, c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline std::vector<c2a_stream_descriptor>
accelerator::enumerate_c2a_streams() const noexcept
{
    auto c2a_stream_count = enyx_hw_accelerator_count_c2a_streams(accelerator_.get());
    std::vector<enyx_hw_c2a_stream_descriptor const *> c_descriptors(c2a_stream_count);
    int ret = enyx_hw_accelerator_enumerate_all_c2a_streams(accelerator_.get(),
                                                      c_descriptors.data(),
                                                      c_descriptors.size());
    if (ret < 0)
        return {};
    std::vector<c2a_stream_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        vec.emplace_back(*this, c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline std::vector<c2a_stream_descriptor>
accelerator::enumerate_c2a_streams(filter const & filter) const noexcept
{
    auto c2a_stream_max = enyx_hw_accelerator_count_c2a_streams(accelerator_.get());
    std::vector<enyx_hw_c2a_stream_descriptor const *> c_descriptors(c2a_stream_max);
    int ret = enyx_hw_accelerator_enumerate_c2a_streams(accelerator_.get(),
                                                  filter.handle(),
                                                  c_descriptors.data(),
                                                  c_descriptors.size());
    if (ret < 0)
        return {};

    std::vector<c2a_stream_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        if (c_descriptor == nullptr)
            break;
        vec.emplace_back(*this, c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline std::vector<a2c_stream_descriptor>
accelerator::enumerate_a2c_streams() const noexcept
{
    auto a2c_stream_count = enyx_hw_accelerator_count_a2c_streams(accelerator_.get());
    std::vector<enyx_hw_a2c_stream_descriptor const *> c_descriptors(a2c_stream_count);
    int ret = enyx_hw_accelerator_enumerate_all_a2c_streams(accelerator_.get(),
                                                      c_descriptors.data(),
                                                      c_descriptors.size());
    if (ret < 0)
        return {};
    std::vector<a2c_stream_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        vec.emplace_back(*this, c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline std::vector<a2c_stream_descriptor>
accelerator::enumerate_a2c_streams(filter const & filter) const noexcept
{
    auto a2c_stream_max = enyx_hw_accelerator_count_a2c_streams(accelerator_.get());
    std::vector<enyx_hw_a2c_stream_descriptor const *> c_descriptors(a2c_stream_max);
    int ret = enyx_hw_accelerator_enumerate_a2c_streams(accelerator_.get(),
                                                  filter.handle(),
                                                  c_descriptors.data(),
                                                  c_descriptors.size());
    if (ret < 0)
        return {};

    std::vector<a2c_stream_descriptor> vec;
    for (auto & c_descriptor : c_descriptors) {
        if (c_descriptor == nullptr)
            break;
        vec.emplace_back(*this, c_descriptor);
        c_descriptor = nullptr;
    }

    return vec;
}

inline enyx_hw_accelerator *
accelerator::handle() noexcept
{
    return accelerator_.get();
}

inline enyx_hw_accelerator const *
accelerator::handle() const noexcept
{
    return accelerator_.get();
}

inline const properties
mmio_descriptor::get_properties() const
{
    return {enyx_hw_mmio_descriptor_get_properties(handle())};
}

inline
mmio_descriptor::mmio_descriptor(accelerator const&  owner,
                                 enyx_hw_mmio_descriptor const * descriptor)
    : accelerator_(owner),
      descriptor_(descriptor, &enyx_hw_mmio_put_descriptor)
{
    if (descriptor_ == nullptr)
        throw std::system_error{EINVAL, std::generic_category()};
}

inline enyx_hw_mmio_descriptor const *
mmio_descriptor::handle() const noexcept
{
    return descriptor_.get();
}

inline accelerator const&
mmio_descriptor::get_accelerator() const noexcept
{
    return accelerator_;
}

inline
a2c_stream_descriptor::a2c_stream_descriptor(accelerator const& owner,
                                             enyx_hw_a2c_stream_descriptor const * descriptor)
    : accelerator_(owner),
      descriptor_(descriptor, &enyx_hw_a2c_stream_put_descriptor)
{
    if (descriptor_ == nullptr)
        throw std::system_error{EINVAL, std::generic_category()};
}

inline const properties
a2c_stream_descriptor::get_properties() const
{
    return {enyx_hw_a2c_stream_descriptor_get_properties(handle())};
}

inline enyx_hw_a2c_stream_descriptor const *
a2c_stream_descriptor::handle() const noexcept
{
    return descriptor_.get();
}

inline accelerator const&
a2c_stream_descriptor::get_accelerator() const noexcept
{
    return accelerator_;
}

inline result<std::uint32_t>
a2c_stream_descriptor::get_mtu() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_mtu(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::size_t>
a2c_stream_descriptor::get_size() const noexcept
{
    std::size_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_size(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::uint32_t>
a2c_stream_descriptor::get_packet_count() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_packet_count(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::uint32_t>
a2c_stream_descriptor::get_backpressure() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_backpressure(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::uint32_t>
a2c_stream_descriptor::get_fifo_errors() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_fifo_errors(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::uint32_t>
a2c_stream_descriptor::get_truncated_count() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_truncated_count(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::uint32_t>
a2c_stream_descriptor::get_errors() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_a2c_stream_descriptor_get_errors(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline
c2a_stream_descriptor::c2a_stream_descriptor(accelerator const& owner,
                                             enyx_hw_c2a_stream_descriptor const * descriptor)
    : accelerator_(owner), descriptor_(descriptor, &enyx_hw_c2a_stream_put_descriptor)
{
    if (descriptor_ == nullptr)
        throw std::system_error{EINVAL, std::generic_category()};
}

inline const properties
c2a_stream_descriptor::get_properties() const
{
    return {enyx_hw_c2a_stream_descriptor_get_properties(handle())};
}

inline enyx_hw_c2a_stream_descriptor const *
c2a_stream_descriptor::handle() const noexcept
{
    return descriptor_.get();
}

inline accelerator const&
c2a_stream_descriptor::get_accelerator() const noexcept
{
    return accelerator_;
}

inline result<std::uint32_t>
c2a_stream_descriptor::get_mtu() const noexcept
{
    std::uint32_t res;
    if (::enyx_hw_c2a_stream_descriptor_get_mtu(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<std::size_t>
c2a_stream_descriptor::get_size() const noexcept
{
    std::size_t res;
    if (::enyx_hw_c2a_stream_descriptor_get_size(handle(), &res) < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

ENYX_HW_NAMESPACE_END
