#pragma once

#include <enyx/hw/c2a_stream.hpp>

#include <enyx/cores/data_stream/sink.hpp>
#include <enyx/cores/namespace.hpp>
#include <enyx/cores/tcp/data_stream.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class TcpSink
{
public:
    TcpSink(hw::c2a_stream && data_out_stream);

    int
    send(std::uint32_t session_id,
         void const * data,
         std::uint32_t size) noexcept;

private:
    hw::c2a_stream stream_;
    data_stream::sink raw_sink_;
    data_stream::sink tcp_sink_;
};

inline int
TcpSink::send(std::uint32_t session_id,
              void const * data,
              std::uint32_t size) noexcept
{
    tcp::metadata metadata{};
    metadata.session_id = session_id;

    return tcp_sink_.send(data, size, &metadata);
}

ENYX_CORES_NAMESPACE_END
