#include <iostream>
#include <sstream>
#include <iomanip>
#include <string>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

template<typename Type>
inline std::istream &
operator>>(std::istream & in, Range<Type> & range)
{
    std::istream::sentry sentry(in);

    if (sentry)
    {
        std::string s;
        in >> s;

        auto const offset = s.find('-');

        Type low, high;
        std::istringstream{s.substr(0, offset)} >> low;

        if (offset == std::string::npos)
            high = low;
        else
            std::istringstream{s.substr(offset + 1)} >> high;

        range = Range<Type>{low, high};
    }

    return in;
}

template<typename Type>
inline std::ostream &
operator<<(std::ostream & out, const Range<Type> & range)
{
    std::ostream::sentry sentry(out);

    if (sentry)
    {
        out << range.low();

        if (range.low() != range.high())
            out << "-" << range.high();
    }

    return out;
}

template<typename Type>
inline std::vector<Type>
as_sequence(const Range<Type> & range)
{
    std::vector<Type> sequence;
    for (auto i = range.low(), e = range.high(); i != e; ++i)
        sequence.push_back(i);

    sequence.push_back(range.high());
    return sequence;
}

ENYX_CORES_NAMESPACE_END
