#pragma once

#include <cstddef>
#include <cstdint>

#include <atomic>
#include <chrono>
#include <future>
#include <queue>
#include <mutex>

#include <enyx/hw/accelerator.hpp>
#include <enyx/hw/a2c_stream.hpp>
#include <enyx/hw/c2a_stream.hpp>
#include <enyx/hw/mmio.hpp>
#include <enyx/hw/core.hpp>
#include <enyx/hw/core_tree.hpp>

#include <enyx/cores/namespace.hpp>
#include <enyx/cores/tcp/context.hpp>
#include <enyx/cores/tcp/tcp.hpp>

#include "ApplicationConfiguration.hpp"
#include "BandwidthThrottle.hpp"
#include "Buffer.hpp"
#include "CacheLine.hpp"
#include "TcpEventSource.hpp"
#include "TcpEventSource.hpp"
#include "TcpSink.hpp"
#include "TcpSource.hpp"

ENYX_CORES_NAMESPACE_BEGIN

enum class TxState {
    READY,
    NOT_READY
};

using Task = std::future<void>;
using Tasks = std::queue<Task>;

template<typename Runtime>
class Application final
{
public:

    explicit
    Application(const ApplicationConfiguration & configuration);

    void
    run();

private:
    void
    loopback_task(std::size_t source_id);

    void
    create_monitoring_tasks();

    void
    create_loopback_data_polling_tasks();

    void
    rx_task(std::size_t source_id);

    void
    create_rx_data_polling_tasks();

    void
    tx_task(std::size_t sink_id);

    void
    create_tx_data_sending_tasks();

    std::error_code
    try_to_send_data(std::uint32_t session_id,
                     std::uint8_t const * data,
                     std::uint32_t size);

    void
    open_sessions(std::uint32_t partitions_count);

    void
    close_session(std::uint32_t session_id, std::chrono::milliseconds delay);

    void
    wait_for_tasks_completion();

    void
    run_loopback();

    void
    run_rx();

    void
    run_tx();

    void
    run_rxtx();

private:
    ApplicationConfiguration const& configuration_;
    hw::accelerator accelerator_;
    hw::mmio mmio_;
    hw::core_tree core_tree_;
    Buffer send_buffer_;
    Runtime runtime_;
    std::mutex tasks_mutex_;
    Tasks tasks_;
};

ENYX_CORES_NAMESPACE_END

#include "Application.ipp"
