#include "ApplicationConfiguration.hpp"

#include <cstring>

#include <stdexcept>
#include <sstream>

ENYX_CORES_NAMESPACE_BEGIN

namespace {

template<typename Iterator>
void
parse_attribute(Iterator i, Iterator e,
                ApplicationConfiguration & configuration)
{
    if (i == e)
        throw std::runtime_error{"Missing attribute argument"};

    if (is_prefix(*i, "vlan"))
    {
        if (++i == e)
            throw std::runtime_error{"vlan attribute requires an argument"};

        configuration.attribute = Attribute::VLAN;
        configuration.attribute_arg = *i;
    }
    else if (is_prefix(*i, "address"))
    {
        if (++i == e)
            throw std::runtime_error{"address attribute requires an argument"};

        configuration.attribute = Attribute::ADDRESS;
        configuration.attribute_arg = *i;
    }
    else if (is_prefix(*i, "gateway"))
    {
        if (++i == e)
            throw std::runtime_error{"gateway attribute requires an argument"};

        configuration.attribute = Attribute::GATEWAY;
        configuration.attribute_arg = *i;
    }
    else if (is_prefix(*i, "configured"))
    {
        if (++i == e)
            throw std::runtime_error{"configured attribute requires an argument"};

        configuration.attribute = Attribute::CONFIGURED;
        configuration.attribute_arg = *i;
    }
    else
    {
        std::ostringstream error;
        error << "unknown attribute '" << *i << "'";
        throw std::runtime_error{error.str()};
    }
}

template<typename Iterator>
void
parse_action(Iterator i, Iterator e,
             ApplicationConfiguration & configuration)
{
    if (i == e)
        throw std::runtime_error{"Missing action argument"};

    if (is_prefix(*i, "show"))
    {
        configuration.action = Action::SHOW;
    }
    else if (is_prefix(*i, "get"))
    {
        if (++i == e)
            throw std::runtime_error{"get action requires an argument"};

        configuration.action = Action::GET;
        configuration.action_arg = *i;
    }
    else if (is_prefix(*i, "set"))
    {
        if (++i == e)
            throw std::runtime_error{"set action requires an argument"};

        configuration.action = Action::SET;
        configuration.action_arg = *i;
    }
    else if (is_prefix(*i, "help"))
    {
        configuration.action = Action::HELP;
    }
    else
    {
        std::ostringstream error;
        error << "unknown action '" << *i << "'";
        throw std::runtime_error{error.str()};
    }

    parse_attribute(++i, e, configuration);
}

} // namespace

ApplicationConfiguration
parse(int argc, char**argv)
{
    ApplicationConfiguration configuration;
    parse_options(argv + 1, argv + argc, configuration);
    return configuration;
}

ENYX_CORES_NAMESPACE_END
