#pragma once
/**
 * @file
 *
 * This function contains the library version and related functions.
 */

#include <stdbool.h>
#include <stdint.h>

#include <enyx/cores_c/symbol_visibility.h>

/// The full enyx cores version.
#define ENYX_CORES_C_VERSION "6.15.0"
/// The major enyx cores version.
#define ENYX_CORES_C_VERSION_MAJOR 6
/// The minor enyx cores version.
#define ENYX_CORES_C_VERSION_MINOR 15
/// The patch enyx cores version.
#define ENYX_CORES_C_VERSION_PATCH 0

/**
 * Get the library version.
 *
 * @note This function returns the version of
 *       the shared/static library.
 *
 * @returns The full version as a string.
 */
ENYX_CORES_C_SYMBOL_VISIBILITY const char *
enyx_cores_version(void);

/**
 * Check if the headers used to compile the current
 * application are compatible with the library used
 * at runtime.
 *
 * @warning It calls `abort()` when an incompatibility is detected.
 *
 * @param major The header major version.
 * @param minor The header minor version.
 * @param patch The header patch version.
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_cores_version_check(uint8_t major, uint8_t minor, uint8_t patch);

/**
 * Check if the headers used to compile the current
 * application are compatible with the library used
 * at runtime.
 */
#define ENYX_CORES_C_VERSION_CHECK() \
    enyx_cores_version_check(ENYX_CORES_C_VERSION_MAJOR, \
                          ENYX_CORES_C_VERSION_MINOR, \
                          ENYX_CORES_C_VERSION_PATCH)
