#pragma once

#include <stddef.h>
#include <stdint.h>
#include <sys/types.h>

#include <enyx/cores_c/symbol_visibility.h>
#include <enyx/hw_c/core.h>

/**
 * AVL MM to ST management object.
 */
typedef struct enyx_mm_to_st enyx_mm_to_st;

/**
 * Write data.
 *
 * @param mm_to_st The MM to ST object to use
 * @param buffer The data to write
 * @param size The data size
 * @return 0 on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_mm_to_st_write(enyx_mm_to_st * mm_to_st, uint8_t const * buffer,
                    size_t size);

/**
 * Get the MTU.
 *
 * @param mm_to_st The MM to ST object to use
 * @return The MTU on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_to_st_get_mtu(enyx_mm_to_st const * mm_to_st);

/**
 * Get the data width.
 *
 * @param mm_to_st The MM to ST object to use
 * @return The data width on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_to_st_get_data_width(enyx_mm_to_st const * mm_to_st);

/**
 * Get the ID width.
 *
 * @param mm_to_st The MM to ST object to use
 * @return The ID width on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_to_st_get_id_width(enyx_mm_to_st const * mm_to_st);

/**
 * Create a MM to ST object from an avl_mm_to_st core.
 *
 * @param core The core to use
 * @return A MM to ST object on success, NULL on error (with @b errno set
 *         accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY enyx_mm_to_st *
enyx_mm_to_st_create(enyx_hw_core * core);

/**
 * Destroy a MM to ST object.
 *
 * @param mm_to_st The MM to ST object to destroy
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_mm_to_st_destroy(enyx_mm_to_st * mm_to_st);
