/// @file hardware_ids.h
#pragma once

#include <stdint.h>

#include <enyx/cores_c/symbol_visibility.h>

/**
 * The tcp std core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_TCP_STD;

/**
 * The udp std core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_UDP_STD;

/**
 * The tcp ull core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_TCP_ULL;

/**
 * The udp ull core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_UDP_ULL;

/**
 * The avl st test point core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_AVL_ST_TEST_POINT;

/**
 * The ethernet interface core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_ETH_IF;

/**
 * The flash manager core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_FLASH_MANAGER;

/**
 * The hardware top core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_HW_TOP;

/**
 * The latency event collector core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_EVENT_COLLECTOR;

/**
 * The latency event probe core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_EVENT_PROBE;

/**
 * The master timestamp generator core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_MTG;

/**
 * The AVL MM from ST core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_MM_FROM_ST;

/**
 * The AVL MM to ST core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_MM_TO_ST;

/**
 * The I2C MM controller core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_I2C_MM_CONTROLLER;

/**
 * The I2C MM bridge core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_I2C_MM_BRIDGE;

/**
 * The SFP controller core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_SFP_CONTROLLER;

/**
 * The muart core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_MUART;

/**
 * The enyx memory tester v2 core hardware id
 */
ENYX_CORES_C_SYMBOL_VISIBILITY uint16_t const ENYX_HARDWARE_ID_ENYX_MEMORY_TESTER_V2;
