ENYX_CORES_NAMESPACE_BEGIN
namespace udp {

inline std::ostream &
operator<<(std::ostream & out, rx_session_state const & state)
{
    switch (state) {
    case rx_session_state::CLOSED:
        return out << "closed";
    case rx_session_state::LISTEN:
        return out << "listen";
    case rx_session_state::LISTEN_MULTICAST:
        return out << "listen multicast";
    }
    return out;
}

inline std::ostream &
operator<<(std::ostream & out, tx_session_state const & state)
{
    switch (state) {
    case tx_session_state::CLOSED:
        return out << "closed";
    case tx_session_state::OPEN:
        return out << "open";
    }
    return out;
}


inline
rx_session::rx_session(std::shared_ptr<::enyx_udp> const & udp,
                       ::enyx_udp_rx_session const & session)
    : udp_(udp)
    , session_(session)
{
}

inline std::uint16_t
rx_session::id() const noexcept
{
    return handle()->session_id;
}

inline result<void>
rx_session::listen(rx_session_parameters const & parameters) noexcept
{
    if (::enyx_udp_rx_session_listen(handle(), &parameters) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
rx_session::listen_multicast(ipv4_address const & multicast_group,
                             rx_session_parameters const & parameters) noexcept
{
    if (::enyx_udp_rx_session_listen_multicast(handle(),
                                                   multicast_group,
                                                   &parameters) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
rx_session::close() noexcept
{
    if (::enyx_udp_rx_session_close(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint16_t>
rx_session::get_source_port() const noexcept
{
    std::uint16_t source_port;
    if (::enyx_udp_rx_session_get_source_port(handle(), &source_port) != 0)
        return std::error_code{errno, std::generic_category()};
    return source_port;
}

inline result<rx_session_state>
rx_session::get_state() const noexcept
{
    ::enyx_udp_rx_session_state ret;
    if (::enyx_udp_rx_session_get_state(handle(), &ret) != 0)
        return std::error_code{errno, std::generic_category()};
    return static_cast<rx_session_state>(ret);
}
inline result<rx_session_statistics>
rx_session::get_statistics() const noexcept
{
    rx_session_statistics statistics{};
    if (::enyx_udp_rx_session_get_statistics(handle(), &statistics) != 0)
        return std::error_code{errno, std::generic_category()};
    return statistics;
}


inline ::enyx_udp_rx_session *
rx_session::handle() noexcept
{
    return &session_;
}

inline ::enyx_udp_rx_session const *
rx_session::handle() const noexcept
{
    return &session_;
}

inline
tx_session::tx_session(std::shared_ptr<::enyx_udp> const & udp,
                       ::enyx_udp_tx_session const & session)
    : udp_(udp)
    , session_(session)
{
}

inline std::uint16_t
tx_session::id() const noexcept
{
    return handle()->session_id;
}

inline result<void>
tx_session::connect(ipv4_address const & peer_address,
                    std::uint16_t peer_port,
                    tx_session_parameters const & parameters) noexcept
{
    if (::enyx_udp_tx_session_connect(handle(),
                                       peer_address,
                                       peer_port,
                                       &parameters) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
tx_session::close() noexcept
{
    if (::enyx_udp_tx_session_close(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint16_t>
tx_session::get_source_port() const noexcept
{
    std::uint16_t source_port;
    if (::enyx_udp_tx_session_get_source_port(handle(), &source_port) != 0)
        return std::error_code{errno, std::generic_category()};
    return source_port;
}

inline result<endpoint>
tx_session::get_peername() const noexcept
{
    endpoint endpoint;
    if (::enyx_udp_tx_session_getpeername(handle(), endpoint) != 0)
        return std::error_code{errno, std::generic_category()};
    return endpoint;
}

inline result<tx_session_state>
tx_session::get_state() const noexcept
{
    ::enyx_udp_tx_session_state ret;
    if (::enyx_udp_tx_session_get_state(handle(), &ret) != 0)
        return std::error_code{errno, std::generic_category()};
    return static_cast<tx_session_state>(ret);
}

inline result<tx_session_statistics>
tx_session::get_statistics() const noexcept
{
    tx_session_statistics statistics{};
    if (::enyx_udp_tx_session_get_statistics(handle(), &statistics) != 0)
        return std::error_code{errno, std::generic_category()};
    return statistics;
}

inline ::enyx_udp_tx_session const *
tx_session::handle() const noexcept
{
    return &session_;
}

inline ::enyx_udp_tx_session *
tx_session::handle() noexcept
{
    return &session_;
}

} /* namespace udp */
ENYX_CORES_NAMESPACE_END
