ENYX_CORES_NAMESPACE_BEGIN
namespace tcp {

inline
session::session(std::shared_ptr<::enyx_tcp> const & tcp,
                 ::enyx_tcp_session const & session)
    : tcp_(tcp)
    , session_(session)
{
}

inline std::uint16_t
session::id() const noexcept
{
    return handle()->session_id;
}

inline result<void>
session::connect(ipv4_address const & peer_address,
                 std::uint16_t peer_port,
                 session_parameters const & parameters) noexcept
{
    if (::enyx_tcp_session_connect(handle(),
                                       peer_address,
                                       peer_port,
                                       &parameters) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
session::listen(session_parameters const & parameters) noexcept
{
    if (::enyx_tcp_session_listen(handle(), &parameters) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
session::close() noexcept
{
    if (::enyx_tcp_session_close(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
session::reset() noexcept
{
    if (::enyx_tcp_session_reset(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
session::set_window_size(std::uint16_t window_size) noexcept
{
    if (::enyx_tcp_session_set_window_size(handle(), window_size) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint16_t>
session::get_window_size() const noexcept
{
    std::uint16_t window_size;
    if (::enyx_tcp_session_get_window_size(handle(), &window_size) != 0)
        return std::error_code{errno, std::generic_category()};
    return window_size;
}

inline result<std::uint32_t>
session::get_init_seqnum() const noexcept
{
    std::uint32_t init_seqnum;
    if (::enyx_tcp_session_get_init_seqnum(handle(), &init_seqnum) != 0)
        return std::error_code{errno, std::generic_category()};
    return init_seqnum;
}

inline result<std::uint16_t>
session::get_source_port() const noexcept
{
    std::uint16_t source_port;
    if (::enyx_tcp_session_get_source_port(handle(), &source_port) != 0)
        return std::error_code{errno, std::generic_category()};
    return source_port;
}

inline result<endpoint>
session::get_peername() const noexcept
{
    endpoint endpoint;
    if (::enyx_tcp_session_getpeername(handle(), endpoint) != 0)
        return std::error_code{errno, std::generic_category()};
    return endpoint;
}

inline result<session_state>
session::get_state() const noexcept
{
    ::enyx_tcp_session_state ret;
    if (::enyx_tcp_session_get_state(handle(), &ret) != 0)
        return std::error_code{errno, std::generic_category()};
    return static_cast<session_state>(ret);
}

inline result<session_statistics>
session::get_statistics() const noexcept
{
    session_statistics statistics{};
    if (::enyx_tcp_session_get_statistics(handle(), &statistics) != 0)
        return std::error_code{errno, std::generic_category()};
    return statistics;
}

inline ::enyx_tcp_session *
session::handle() noexcept
{
    return &session_;
}

inline ::enyx_tcp_session const *
session::handle() const noexcept
{
    return &session_;
}

inline std::ostream &
operator<<(std::ostream & out, session_state const & state)
{
    switch (state) {
    case session_state::CLOSED:
        return out << "closed";
    case session_state::OPENING:
        return out << "opening";
    case session_state::ESTABLISHED:
        return out << "established";
    case session_state::CLOSING:
        return out << "closing";
    }
    return out;
}

} /* namespace tcp */
ENYX_CORES_NAMESPACE_END
