ENYX_CORES_NAMESPACE_BEGIN
namespace raw_ethernet {

inline
raw_ethernet::raw_ethernet(enyx::hw::core const& raw_ethernet_core)
    : raw_ethernet_core_(raw_ethernet_core),
      raw_ethernet_(::enyx_raw_ethernet_create(raw_ethernet_core_.handle()))

{
    if (! raw_ethernet_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create raw_ethernet"};
}

inline enyx::hw::core
raw_ethernet::get_core() const noexcept
{
    return raw_ethernet_core_;
}

inline enyx::result<std::uint8_t>
raw_ethernet::get_mac_data_width() const noexcept
{
    std::uint8_t result;

    if (::enyx_raw_ethernet_get_mac_data_width(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline enyx::result<std::uint8_t>
raw_ethernet::get_data_width() const noexcept
{
    std::uint8_t result;

    if (::enyx_raw_ethernet_get_data_width(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline bool
raw_ethernet::capture_enabled() const noexcept
{
    return ::enyx_raw_ethernet_capture_enabled(handle());
}

inline result<void>
raw_ethernet::enable_capture() noexcept
{
    if (::enyx_raw_ethernet_enable_capture(handle()) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline result<void>
raw_ethernet::disable_capture() noexcept
{
    if (::enyx_raw_ethernet_disable_capture(handle()) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return {};
}

inline bool
raw_ethernet::rx_interface_available() const noexcept
{
    return ::enyx_raw_ethernet_rx_interface_available(handle());
}

inline enyx::result<std::uint32_t>
raw_ethernet::get_rx_packet_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_raw_ethernet_get_rx_packet_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline enyx::result<std::uint32_t>
raw_ethernet::get_rx_error_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_raw_ethernet_get_rx_error_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline bool
raw_ethernet::tx_interface_available() const noexcept
{
    return ::enyx_raw_ethernet_tx_interface_available(handle());
}

inline enyx::result<std::uint32_t>
raw_ethernet::get_tx_packet_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_raw_ethernet_get_tx_packet_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline enyx::result<std::uint32_t>
raw_ethernet::get_tx_error_count() const noexcept
{
    std::uint32_t result;

    if (::enyx_raw_ethernet_get_tx_error_count(handle(), &result) < 0) {
        return std::error_code{errno, std::generic_category()};
    }

    return result;
}

inline ::enyx_raw_ethernet *
raw_ethernet::handle() const noexcept
{
    return raw_ethernet_.get();
}

} /* namespace raw_ethernet */
ENYX_CORES_NAMESPACE_END
