ENYX_CORES_NAMESPACE_BEGIN

namespace probes {

inline std::ostream &
operator<<(std::ostream & out, duration const& d)
{
    std::ios old_state{nullptr};
    old_state.copyfmt(out);

    if (d.is_neg)
        out << '-';
    out << d.s << "."
        << std::setfill('0') << std::setw(9) << d.ns;

    auto const fns = d.fns / double(1UL << 16);

    // handle fractionnal part
    char buffer[16];
    if (std::snprintf(buffer, sizeof(buffer), "%f", fns) > 1)
    {
        assert(buffer[0] == '0' && buffer[1] == '.' && "fns starts with 0.");
        out << &buffer[2];
    }

    out.copyfmt(old_state);

    return out;
}

inline ts_64_v1
ts_parse_64_v1(void const* data)
{
    return ::enyx_probes_ts_parse_64_v1(data);
}

inline duration
operator-(ts_64_v1 const& a, ts_64_v1 const& b)
{
    return ::enyx_probes_ts_64_v1_to_duration(&a, &b);
}

inline std::ostream &
operator<<(std::ostream & out, ts_64_v1 const& ts)
{
    char buffer[128];
    auto const count = enyx_probes_ts_print_64_v1(&ts, buffer,
                                                  sizeof(buffer));
    if (count < 0 || size_t(count) >= sizeof(buffer))
        throw std::runtime_error{"Failed to convert timestamp"};

    return out << buffer;
}

inline ts_96_v1
ts_parse_96_v1(void const* data)
{
    return ::enyx_probes_ts_parse_96_v1(data);
}

inline duration
operator-(ts_96_v1 const& a, ts_96_v1 const& b)
{
    return ::enyx_probes_ts_96_v1_to_duration(&a, &b);
}

inline std::ostream &
operator<<(std::ostream & out, ts_96_v1 const& ts)
{
    char buffer[128];
    auto const count = enyx_probes_ts_print_96_v1(&ts, buffer,
                                                  sizeof(buffer));
    if (count < 0 || size_t(count) >= sizeof(buffer))
        throw std::runtime_error{"Failed to convert timestamp"};

    return out << buffer;
}

inline std::ostream &
operator<<(std::ostream & out, ts_format const& format)
{
    switch(format)
    {
    case ENYX_PROBES_TS_96_V1:
        return out << "TS_96_V1";
    case ENYX_PROBES_TS_64_V1:
        return out << "TS_64_V1";
    default:
        throw std::runtime_error{"Unknown enyx_probes_ts_format"};
    }
}

} /* namespace probes */

ENYX_CORES_NAMESPACE_END
