#pragma once

#include <memory>

#include <enyx/cores/namespace.hpp>
#include <enyx/cores/result.hpp>
#include <enyx/hw/core.hpp>

#include <enyx/cores_c/mm_to_st/mm_to_st.h>

/// @cond
namespace std {

template<>
struct default_delete<::enyx_mm_to_st>
{
    void
    operator()(::enyx_mm_to_st * ptr) const
    {
        ::enyx_mm_to_st_destroy(ptr);
    }
};

} // namespace std
/// @endcond

ENYX_CORES_NAMESPACE_BEGIN

namespace mm_to_st {

/**
 * @copydoc ::enyx_mm_to_st
 */
class mm_to_st {
public:
    /**
     * Create a MM to ST object from an avl_mm_to_st core.
     *
     * @param core The core to use
     *
     * @throw std::system_error on failure.
     */
    mm_to_st(enyx::hw::core & core);

    /**
     * Write data.
     *
     * @param buffer The data to write
     * @param size The data size
     * @return An error in case of error
     */
    result<void>
    write(uint8_t const * buffer, size_t size) noexcept;

    /**
     * Get the MTU.
     *
     * @return A result containing the MTU on success, or an error
     */
    result<size_t>
    get_mtu() const noexcept;

    /**
     * Get the data width.
     *
     * @return A result containing the data width on success, or an error
     */
    result<size_t>
    get_data_width() const noexcept;

    /**
     * Get the ID width.
     *
     * @return A result containing the ID width on success, or an error
     */
    result<size_t>
    get_id_width() const noexcept;

    /**
     * Get a const pointer to the underlying @b C handle.
     *
     * @return A const pointer to a @ref enyx_mm_to_st
     */
    enyx_mm_to_st const *
    handle() const noexcept;

    /**
     * Get a pointer to the underlying @b C handle.
     *
     * @return A pointer to a @ref enyx_mm_to_st
     */
    enyx_mm_to_st *
    handle() noexcept;

private:
    std::unique_ptr<enyx_mm_to_st> mm_to_st_c_;
};

} /* namespace mm_to_st */

ENYX_CORES_NAMESPACE_END

#include <enyx/cores/mm_to_st/mm_to_st.ipp>
