ENYX_CORES_NAMESPACE_BEGIN

namespace mm_from_st {

inline
mm_from_st::mm_from_st(enyx::hw::core & core)
    :mm_from_st_c_(enyx_mm_from_st_create(core.handle()))
{
    if (! mm_from_st_c_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create mm_from_st object."};
}

inline result<size_t>
mm_from_st::read(uint8_t * buffer, size_t size) noexcept
{
    auto res = enyx_mm_from_st_read(handle(), buffer, size);
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<size_t>
mm_from_st::get_mtu() const noexcept
{
    auto res = enyx_mm_from_st_get_mtu(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<size_t>
mm_from_st::get_data_width() const noexcept
{
    auto res = enyx_mm_from_st_get_data_width(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline result<size_t>
mm_from_st::get_id_width() const noexcept
{
    auto res = enyx_mm_from_st_get_id_width(handle());
    if (res < 0)
        return std::error_code{errno, std::generic_category()};
    return res;
}

inline enyx_mm_from_st const *
mm_from_st::handle() const noexcept
{
    return mm_from_st_c_.get();
}

enyx_mm_from_st *
mm_from_st::handle() noexcept
{
    return mm_from_st_c_.get();
}

} /* namespace mm_from_st */

ENYX_CORES_NAMESPACE_END
