#pragma once

#define ENYX_CORES_DEFAULT_DELETE(SYS) \
    namespace std { \
    template<> \
    struct default_delete<::enyx_##SYS> \
    { \
        void \
        operator()(::enyx_##SYS * ptr) const \
        { \
            ::enyx_##SYS##_destroy(ptr); \
        } \
    }; \
    }

#ifdef ENYX_CORES_DISABLE_DEPRECATED_WARNING
#   define ENYX_CORES_CXX_DEPRECATED(msg)
#else
#   if __cplusplus >= 201402L
#       define ENYX_CORES_CXX_DEPRECATED(msg) [[ deprecated(msg) ]]
#   else
#       define ENYX_CORES_CXX_DEPRECATED(msg) __attribute__((deprecated))
#   endif
#endif

/**
 * @def ENYX_CORES_CXX_DEPRECATED
 *
 * Flag the following function as deprecated.
 *
 * @since 6.9.0
 */
