ENYX_CORES_NAMESPACE_BEGIN
namespace arp {

inline
arp::arp(enyx::hw::core const& arp_core)
    : arp_core_(arp_core),
      handle_(::enyx_arp_create(arp_core_.handle()))

{
    if (! handle_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create arp"};
}

inline enyx::hw::core
arp::get_core() const noexcept
{
    return arp_core_;
}

inline bool
arp::is_server_available() const noexcept
{
    return ::enyx_arp_server_available(handle());
}

inline bool
arp::is_client_available() const noexcept
{
    return ::enyx_arp_client_available(handle());
}

inline bool
arp::is_server_enabled() const noexcept
{
    return ::enyx_arp_server_enabled(handle());
}

inline result<void>
arp::enable_server() noexcept
{
    if (::enyx_arp_server_enable(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
arp::disable_server() noexcept
{
    if (::enyx_arp_server_disable(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint16_t>
arp::get_client_timeout() const noexcept
{
    uint16_t result;
    if (::enyx_arp_get_client_timeout(handle(), &result) != 0)
        return std::error_code{errno, std::generic_category()};
    return result;
}

inline result<void>
arp::set_client_timeout(std::uint16_t timeout_ms) noexcept
{
    if (::enyx_arp_set_client_timeout(handle(), timeout_ms) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint16_t>
arp::get_dynamic_lifetime() const noexcept
{
    std::uint16_t result;
    if (::enyx_arp_table_get_dynamic_lifetime(handle(), &result) != 0)
        return std::error_code{errno, std::generic_category()};
    return result;
}

inline result<void>
arp::set_dynamic_lifetime(std::uint16_t lifetime_s) noexcept
{
    if (::enyx_arp_table_set_dynamic_lifetime(handle(), lifetime_s) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline std::uint16_t
arp::table_get_max_entry_count() const noexcept
{
    return ::enyx_arp_table_get_max_entry(handle());
}

inline result<void>
arp::table_add_entry(arp_entry const & entry) noexcept
{
    if (::enyx_arp_table_add_entry(handle(), entry.ipv4, entry.mac) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<mac_address>
arp::table_find_mac(ipv4_address ipv4) noexcept
{
    mac_address result;
    if (::enyx_arp_table_find_mac(handle(), ipv4, result) != 0)
        return std::error_code{errno, std::generic_category()};
    return result;
}

inline result<arp_entry>
arp::table_get_entry(std::uint16_t entry_id) const noexcept
{
    arp_entry result;
    if (::enyx_arp_table_get_entry(handle(),
                                        entry_id,
                                        result.ipv4,
                                        result.mac) != 0)
        return std::error_code{errno, std::generic_category()};
    return result;
}

inline result<void>
arp::table_delete_entry(ipv4_address ipv4) noexcept
{
    if (::enyx_arp_table_delete_entry(handle(), ipv4) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
arp::table_flush_dynamic_entries() noexcept
{
    if (::enyx_arp_table_flush_dynamic_entries(handle()) != 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline ::enyx_arp *
arp::handle() const noexcept
{
    return handle_.get();
}

} /* namespace arp */
ENYX_CORES_NAMESPACE_END
