/*
 * HFP id core interface.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HFP_ID_USR_H
#define HFP_ID_USR_H

#include <linux/kernel.h>

#include "enyx_hfp_bus.h"

struct enyx_hfp_id_usr;

struct enyx_hfp_id_usr *
enyx_hfp_id_usr_create(struct enyx_hfp_device * parent);

void
enyx_hfp_id_usr_destroy(struct enyx_hfp_id_usr * dev);

int
enyx_hfp_id_class_register(void);

void
enyx_hfp_id_class_unregister(void);

#endif /* HFP_ID_USR_H */

