#pragma once
/**
 * @file
 *
 * This function contains the library version and related functions.
 */

#include <stdbool.h>
#include <stdint.h>

#include <enyx/log/symbol_visibility.h>

/// The full enyx log version.
#define ENYX_LOG_C_VERSION "4.0.6"
/// The major enyx log version.
#define ENYX_LOG_C_VERSION_MAJOR 4
/// The minor enyx log version.
#define ENYX_LOG_C_VERSION_MINOR 0
/// The patch enyx log version.
#define ENYX_LOG_C_VERSION_PATCH 6

/**
 * Get the library version.
 *
 * @note This function returns the version of
 *       the shared/static library.
 *
 * @returns The full version as a string.
 * @since 5.0.0
 */
ENYX_LOG_C_SYMBOL_VISIBILITY const char *
enyx_log_version(void);

/**
 * Check if the headers used to compile the current
 * application are compatible with the library used
 * at runtime.
 *
 * @warning It calls `abort()` when an incompatibility is detected.
 *
 * @param major The header major version.
 * @param minor The header minor version.
 * @param patch The header patch version.
 * @since 5.0.0
 */
ENYX_LOG_C_SYMBOL_VISIBILITY void
enyx_log_version_check(uint8_t major, uint8_t minor, uint8_t patch);

/**
 * Check if the headers used to compile the current
 * application are compatible with the library used
 * at runtime.
 * @since 5.0.0
 */
#define ENYX_LOG_C_VERSION_CHECK() \
    enyx_log_version_check(ENYX_LOG_C_VERSION_MAJOR, \
                          ENYX_LOG_C_VERSION_MINOR, \
                          ENYX_LOG_C_VERSION_PATCH)

