#pragma once
#include <unordered_map>

#include <enyx/cores/tcp/tcp.hpp>
#include <enyx/cores/tcp/context.hpp>

namespace enyx {
namespace fix {

class Acceptor;
class TcpSessionManager {
public:
    TcpSessionManager(tcp::tcp const & tcp,
                      Acceptor & acceptor);

    std::uint32_t
    add_session(tcp::session_parameters const & params);

    bool
    is_managed(std::uint16_t session_id);

    void
    on_status_event(std::uint32_t session_id, tcp::state new_state,
                    tcp::state_info const * state_info);

    void
    on_credit_event(std::uint32_t session_id, std::uint32_t credit);

    void
    on_event_error();
private:
    tcp::tcp tcp_;
    Acceptor & acceptor_;

    std::unordered_map<std::uint16_t, tcp::session_parameters> sessions_;
};

}
}
