#pragma once
#include <cstdint>
#include <vector>

namespace enyx::fix {

struct [[gnu::packed]] SourceHeader {
    std::uint8_t event_type;
};

/**
 * The header for any FIX event received from the hardware.
 */
struct [[gnu::packed]] FixSourceHeader {
    /**
     * The type of event as described in @ref EventType::EventType
     */
    std::uint8_t type;
    /**
     * The corresponding FIX session id
     */
    std::uint32_t session_id;
    /**
     * The engine internal SeqID that matches events seen in the @ref Audit
     */
    std::uint64_t seq_id;
};

struct [[gnu::packed]] SinkHeader {
    std::uint8_t event_type; // unused
    std::uint8_t type; //unused
    std::uint32_t fix_session_id;
};

struct [[gnu::packed]] FixMsgHeader {
    char msgType[2];
};

struct [[gnu::packed]] FixTagHeader {
    std::uint16_t tagId;
    std::uint8_t typeId;
};

struct [[gnu::packed]] FixErrHeader {
    std::uint8_t errorCode;
    std::uint8_t errorData[8];
};

struct [[gnu::packed]] AuditHeader {
    std::uint8_t direction;
    std::uint64_t seq_id;
};

using send_buffer = std::vector<std::uint8_t>;
}
