#pragma once

#include <stdexcept>

namespace enyx {
namespace fix {

class FixError: public std::runtime_error {
public:
    FixError(std::string const & message)
        : std::runtime_error{message}
    {}
};

// Internal errors
class BadBeginString: public FixError {
public:
      BadBeginString()
          : FixError{"Bad Begin String"}
      {}
};

class BadCompID: public FixError {
public:
      BadCompID()
          : FixError{"Bad CompID"}
      {}
};

class SeqNumTooHigh: public FixError {
public:
      SeqNumTooHigh()
          : FixError{"SeqNum too high"}
      {}
};

class SeqNumTooLow: public FixError {
public:
      SeqNumTooLow()
          : FixError{"SeqNum too low"}
      {}
};

}
}
