/*
 * HFP char device region interface.
 * Copyright (C) 2016 David Keller <david.keller@enyx.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HFP_IRQ_LIST_H
#define HFP_IRQ_LIST_H

#include <linux/types.h>

struct enyx_hfp_irq_list;

struct enyx_hfp_irq_list *
enyx_hfp_irq_list_create(size_t capacity);

void
enyx_hfp_irq_list_destroy(struct enyx_hfp_irq_list * irq_list);

int
enyx_hfp_irq_list_get(struct enyx_hfp_irq_list * irq_list,
                 int * irq, int * index);

int
enyx_hfp_irq_list_put(struct enyx_hfp_irq_list * irq_list,
                 int irq, int index);

#endif // HFP_IRQ_LIST_H

