#pragma once
/**
 * @file
 *
 * This function contains the library version and related functions.
 */

#include <stdbool.h>
#include <stdint.h>

#include <enyx/hw_c/symbol_visibility.h>

/// The full enyx hw version.
#define ENYX_HW_C_VERSION "5.12.0"
/// The major enyx hw version.
#define ENYX_HW_C_VERSION_MAJOR 5
/// The minor enyx hw version.
#define ENYX_HW_C_VERSION_MINOR 12
/// The patch enyx hw version.
#define ENYX_HW_C_VERSION_PATCH 0

/**
 * Get the library version.
 *
 * @note This function returns the version of
 *       the shared/static library.
 *
 * @returns The full version as a string.
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY const char *
enyx_hw_version(void);

/**
 * Check if the headers used to compile the current
 * application are compatible with the library used
 * at runtime.
 *
 * @warning It calls `abort()` when an incompatibility is detected.
 *
 * @param major The header major version.
 * @param minor The header minor version.
 * @param patch The header patch version.
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY void
enyx_hw_version_check(uint8_t major, uint8_t minor, uint8_t patch);

/**
 * Check if the headers used to compile the current
 * application are compatible with the library used
 * at runtime.
 * @since 5.0.0
 */
#define ENYX_HW_C_VERSION_CHECK() \
    enyx_hw_version_check(ENYX_HW_C_VERSION_MAJOR, \
                          ENYX_HW_C_VERSION_MINOR, \
                          ENYX_HW_C_VERSION_PATCH)

