/**
 * @file
 *
 * This file contains the preprocessor definition used to control
 * the function symbol visibility.
 */

#pragma once

#ifdef __cplusplus
#   define ENYX_HW_C_SYMBOL_VISIBILITY extern "C" __attribute__((visibility("default")))
#else
#   define ENYX_HW_C_SYMBOL_VISIBILITY __attribute__((visibility("default")))
#endif

#ifdef ENYX_HW_DISABLE_DEPRECATED_WARNING
#   define ENYX_HW_C_DEPRECATED(msg)
#else
#   define ENYX_HW_C_DEPRECATED(msg) __attribute__((deprecated(msg)))
#endif

/**
 * @def ENYX_HW_C_SYMBOL_VISIBILITY
 *
 * Set the shared library symbol visibility.
 *
 * @since 5.0.0
 */

/**
 * @def ENYX_HW_C_DEPRECATED
 *
 * Flag the function as deprecated.
 *
 * @since 5.6.0
 */
