#pragma once

#include <enyx/hw_c/symbol_visibility.h>

/**
 * @enum enyx_hw_log_level
 *
 * @since 5.0.0
 */
typedef enum enyx_hw_log_level {
    ENYX_HW_LOG_EMERG,
    ENYX_HW_LOG_ALERT,
    ENYX_HW_LOG_CRIT,
    ENYX_HW_LOG_ERR,
    ENYX_HW_LOG_WARNING,
    ENYX_HW_LOG_NOTICE,
    ENYX_HW_LOG_INFO,
    ENYX_HW_LOG_DEBUG,
} enyx_hw_log_level;

/**
 * @typedef enyx_hw_log_handler
 *
 * @param level The log level of the current log message.
 * @param msg The message to be printed.
 *
 * @since 5.0.0
 */
typedef void (*enyx_hw_log_handler)(enyx_hw_log_level level, char const * msg);

/**
 * Set the function used to log messages.
 *
 * This is used for internal errors that cannot be reported easily, i.e.
 * an xml parser error or a hardware core has corrupted metadata.
 *
 * @param handler The new function.
 * @return 0 on success, -1 on failure with errno set to @b EINVAL
 *
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY
int enyx_hw_set_log_function(enyx_hw_log_handler handler);

/**
 * Get the current function used to log messages.
 *
 * @return The current log function
 *
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY
enyx_hw_log_handler enyx_hw_get_log_function(void);

/**
 * The default log function.
 *
 * @param level The log level of the current log message.
 * @param msg The message to be printed.
 *
 * @since 5.0.0
 */
ENYX_HW_C_SYMBOL_VISIBILITY
void enyx_hw_default_log_function(enyx_hw_log_level level, char const * msg);
