/**
 *  @file
 *
 *  Contains forward declaration of the devices types.
 */
#pragma once

/**
 * Opaque class representing an accelerator.
 *
 * This class can be used to get channels to an hardware accelerator
 * and to query its properties.
 */
typedef struct enyx_hw_accelerator enyx_hw_accelerator;

/**
 * This class allows @b 1 to @b 8 bytes accesses within the
 * accelerators address space.
 *
 * @since 5.0.0
 */
typedef struct enyx_hw_mmio enyx_hw_mmio;

/**
 * This class allows Accelerator to CPU streaming data transferts
 *
 * @since 5.0.0
 */
typedef struct enyx_hw_a2c_stream enyx_hw_a2c_stream;

/**
 * This class allows CPU to Accelerator streaming data transferts
 *
 * @since 5.0.0
 */
typedef struct enyx_hw_c2a_stream enyx_hw_c2a_stream;

