ENYX_HW_NAMESPACE_BEGIN

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
inline
mocked_mmio::mocked_mmio(mocking::mock & mock_instance,
                         mocking::mocked_core & root,
                         std::uint8_t addr_width)
    : mmio(root, addr_width),
      mock_(mock_instance)
{
    mock_.count_mmios = [] (std::uint32_t)
    {
        return std::size_t(1);
    };

    mock_.get_mmio_size = [this] (std::uint32_t,
                                  std::uint32_t,
                                  size_t * size) -> int
    {
        *size = get_size();
        return 0;
    };

    mock_.get_mmio_uid = [this] (std::uint32_t, std::uint32_t,
                                 char * buffer,
                                 size_t capacity) -> int
    {
        const auto uid = get_uid();
        std::strncpy(buffer, uid.c_str(), capacity);
        return uid.size() + 1;
    };

    mock_.mmio_write_8 = [this] (std::uint32_t, std::uint32_t,
                                 std::uint64_t address, std::uint8_t value)
    {
        if (! write_8) {
        }
        return write_8(address, value);
    };

    mock_.mmio_write_16 = [this] (std::uint32_t, std::uint32_t,
                                  std::uint64_t address, std::uint16_t value)
    {
        return write_16(address, value);
    };

    mock_.mmio_write_32 = [this] (std::uint32_t, std::uint32_t,
                                  std::uint64_t address, std::uint32_t value)
    {
        return write_32(address, value);
    };

    mock_.mmio_write_64 = [this] (std::uint32_t, std::uint32_t,
                                  std::uint64_t address, std::uint64_t value)
    {
        return write_64(address, value);
    };

    mock_.mmio_read_8 = [this] (std::uint32_t, std::uint32_t,
                                std::uint64_t address, std::uint8_t * value)
    {
        return read_8(address, value);
    };

    mock_.mmio_read_16 = [this] (std::uint32_t, std::uint32_t,
                                 std::uint64_t address, std::uint16_t * value)
    {
        return read_16(address, value);
    };

    mock_.mmio_read_32 = [this] (std::uint32_t, std::uint32_t,
                                 std::uint64_t address, std::uint32_t * value)
    {
        return read_32(address, value);
    };

    mock_.mmio_read_64 = [this] (std::uint32_t, std::uint32_t,
                                 std::uint64_t address, std::uint64_t * value)
    {
        return read_64(address, value);
    };
}
#pragma GCC diagnostic pop

inline
mocked_mmio::~mocked_mmio()
{
    mock_.count_mmios = nullptr;
    mock_.get_mmio_size = nullptr;
    mock_.get_mmio_uid = nullptr;

    mock_.mmio_write_8 = nullptr;
    mock_.mmio_write_16 = nullptr;
    mock_.mmio_write_32 = nullptr;
    mock_.mmio_write_64 = nullptr;

    mock_.mmio_read_8 = nullptr;
    mock_.mmio_read_16 = nullptr;
    mock_.mmio_read_32 = nullptr;
    mock_.mmio_read_64 = nullptr;
}

ENYX_HW_NAMESPACE_END
