#pragma once

#include <utility>
#include <enyx/hw/a2c_stream.hpp>

#include <enyx/cores/namespace.hpp>
#include <enyx/cores/data_stream/hw_source.hpp>
#include <enyx/cores/tcp/data_stream.hpp>

ENYX_CORES_NAMESPACE_BEGIN

class TcpSource
{
public:
    TcpSource(hw::a2c_stream && data_in_stream);

    template<typename OnData>
    int
    poll_once(OnData && on_data);

private:
    hw::a2c_stream stream_;
};

template<typename OnData>
inline int
TcpSource::poll_once(OnData && on_data)
{
    auto on_data_wrapper = [&](std::uint8_t const * data,
                               std::uint32_t size,
                               void const * metadata)
    {
        using metadata_t = tcp::metadata const*;
        on_data(reinterpret_cast<metadata_t>(metadata)->session_id,
                data, size);
    };

    auto source = tcp::source(on_data_wrapper);
    auto raw_source = data_stream::hw_source(stream_, source);

    return raw_source.poll_once().value();
}

ENYX_CORES_NAMESPACE_END
