#pragma once

#include <cstdint>
#include <string>
#include <iosfwd>
#include <vector>

#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN

struct SessionConfiguration
{
    enum Type { CLIENT, SERVER };

    std::uint32_t interface_id;
    Type type;
    std::string endpoint;
};

std::istream &
operator>>(std::istream & in, SessionConfiguration::Type & type);

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration::Type & type);

std::ostream &
operator<<(std::ostream & out, const SessionConfiguration & configuration);

using SessionConfigurations = std::vector<SessionConfiguration>;

ENYX_CORES_NAMESPACE_END
