#include "Executable.hpp"

#include <enyx/cores/namespace.hpp>

#include "ConfigurationParser.hpp"
#include "../lib/SignalHandler.hpp"
#include "Application.hpp"

ENYX_CORES_NAMESPACE_BEGIN

namespace Executable {

void
run(int argc, char** argv)
{
    install_signal_handlers();

    auto const configuration = parse_configuration(argc, argv);
    Application{configuration}.run();
}

} // namespace Executable

ENYX_CORES_NAMESPACE_END
