#pragma once

#include <csignal>
#include <cstdint>
#include <enyx/hw/accelerator.hpp>
#include <enyx/hw/mmio.hpp>
#include <enyx/hw/core_tree.hpp>
#include <enyx/cores/tcp/tcp.hpp>
#include <enyx/cores/tcp/session_monitor.hpp>

#include <enyx/cores/namespace.hpp>
#include "ApplicationConfiguration.hpp"

ENYX_CORES_NAMESPACE_BEGIN

class Application {
public:
    Application(ApplicationConfiguration const & configuration);

    void
    run();

private:
    void
    open_sessions();

    void
    open_session(std::uint16_t session_id,
                 SessionConfiguration const & session_configuration);

    void
    connect_session(std::uint16_t session_id,
                       SessionConfiguration const & session_configuration);

    void
    listen_on_session(std::uint16_t session_id,
                      SessionConfiguration const & session_configuration);

private:
    ApplicationConfiguration const & configuration_;
    hw::accelerator accelerator_;
    hw::mmio mmio_;
    hw::core_tree core_tree_;
    tcp::tcp tcp_;
    tcp::session_monitor monitor_;
    std::uint16_t open_session_count_;
};

ENYX_CORES_NAMESPACE_END
