#include <cassert>
#include <cstdint>
#include <enyx/cores/namespace.hpp>

ENYX_CORES_NAMESPACE_BEGIN
class Stopwatch final
{
public:
    Stopwatch()
        : begin_{}
        , end_{}
    {}

    void
    start()
    {
        begin_ = read_timestamp_counter();
    }

    void
    stop()
    {
        end_ = read_timestamp_counter();
    }

    std::uint64_t
    get() const
    {
        return diff_timestamps(begin_, end_);
    }

private:
    struct timestamp final {
        std::uint32_t coreId;
        std::uint64_t value;
    };

    static timestamp
    read_timestamp_counter() {
        timestamp t;
        std::uint64_t highTick, lowTick;
        asm volatile ("rdtscp" : "=d"(highTick), "=a"(lowTick), "=c"(t.coreId));
        t.value = highTick << 32 | lowTick;
        return t;
    }

    static uint64_t
    diff_timestamps(const timestamp & before, const timestamp & after) {
        assert(before.coreId == after.coreId);
        return after.value - before.value;
    }

private:
    timestamp begin_;
    timestamp end_;
};

ENYX_CORES_NAMESPACE_END
