/**
 *  @file
 *
 *  Contains the types and functions related to the MTG device.
 */
#pragma once

#include <enyx/hw_c/core.h>

#include <enyx/cores_c/probes/timestamp.h>
#include <enyx/cores_c/symbol_visibility.h>

/**
 * Opaque class representing a mtg.
 *
 * This class can be used to query the mtg and configure it.
 *
 * @since 6.7.0
 */
typedef struct enyx_probes_mtg enyx_probes_mtg;

/**
 * Create a mtg.
 *
 * @param root The root core
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY enyx_probes_mtg *
enyx_probes_mtg_create(enyx_hw_core const * root);

/**
 * Release a mtg.
 *
 * @param mtg MTG to release.
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_probes_mtg_destroy(enyx_probes_mtg * mtg);

/**
 * Retrieve a mtg timestamp format.
 *
 * @param mtg MTG to query.
 * @param ts_format The timestamp format
 * @return 0 on success, -1 on error (with @b errno set accordingly)
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY int
enyx_probes_mtg_get_ts_format(enyx_probes_mtg const * mtg,
                              enyx_probes_ts_format * ts_format);
