/**
 * @file
 *
 * Contains the types and functions related to the collector.
 */
#pragma once

#include <stdint.h>

#include <enyx/hw_c/accelerator.h>
#include <enyx/hw_c/mmio.h>

#include <enyx/cores_c/symbol_visibility.h>

#include <enyx/cores_c/probes/data_stream.h>

/**
 * Represents an events collector.
 *
 * This class can be used to retrieve events.
 *
 * @since 6.7.0
 */
typedef struct enyx_probes_collector enyx_probes_collector;

/**
 * Create an event collector from a @p collector_core.
 *
 * @param collector_core The event collector core.
 * @return The requested event collector on success, @b NULL on error with
 * errno set.
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY enyx_probes_collector *
enyx_probes_collector_create(enyx_hw_core * collector_core);

/**
 * Destroy a collector.
 *
 * @param collector collector destroy.
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_probes_collector_destroy(enyx_probes_collector * collector);

/**
 * Get the collector name.
 *
 * @param collector collector to query.
 * @return the collector name on success, @b NULL with errno set on failure.
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY char const*
enyx_probes_collector_get_name(enyx_probes_collector const* collector);

/**
 * Get the collector DMA stream name.
 *
 * @param collector collector to query.
 * @return the collector stream name on success, @b NULL with errno set on
 * failure.
 *
 * @since 6.7.0
 */
ENYX_CORES_C_SYMBOL_VISIBILITY char const*
enyx_probes_collector_get_stream_name(enyx_probes_collector const* collector);
