#pragma once

#include <stddef.h>
#include <stdint.h>
#include <sys/types.h>

#include <enyx/cores_c/symbol_visibility.h>
#include <enyx/hw_c/core.h>

/**
 * AVL MM from ST management object.
 */
typedef struct enyx_mm_from_st enyx_mm_from_st;

/**
 * Read a data packet.
 *
 * @param mm_from_st The MM from ST object to use
 * @param buffer The buffer to fill
 * @param size The buffer size
 * @return The packet size on success, -1 on error (with @b errno set
 *         accordingly).
 * @note The returned packet size can be bigger than the given buffer size. In
 *       that case, the remaining data is flushed.
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_from_st_read(enyx_mm_from_st * mm_from_st, uint8_t * buffer,
                     size_t size);

/**
 * Get the MTU.
 *
 * @param mm_from_st The MM from ST object to use
 * @return The MTU on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_from_st_get_mtu(enyx_mm_from_st const * mm_from_st);

/**
 * Get the data width.
 *
 * @param mm_from_st The MM from ST object to use
 * @return The data width on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_from_st_get_data_width(enyx_mm_from_st const * mm_from_st);

/**
 * Get the ID width.
 *
 * @param mm_from_st The MM from ST object to use
 * @return The ID width on success, -1 on error (with @b errno set accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY ssize_t
enyx_mm_from_st_get_id_width(enyx_mm_from_st const * mm_from_st);

/**
 * Create a MM from ST object from an avl_mm_from_st core.
 *
 * @param core The core to use
 * @return A MM from ST object on success, NULL on error (with @b errno set
 *         accordingly)
 */
ENYX_CORES_C_SYMBOL_VISIBILITY enyx_mm_from_st *
enyx_mm_from_st_create(enyx_hw_core * core);

/**
 * Destroy a MM from ST object.
 *
 * @param mm_from_st The MM from ST object to destroy
 */
ENYX_CORES_C_SYMBOL_VISIBILITY void
enyx_mm_from_st_destroy(enyx_mm_from_st * mm_from_st);
