#pragma once

#include <enyx/cores_c/tcp/emi_control.h>

#include <enyx/cores/data_stream/sink.hpp>
#include <enyx/cores/macros.hpp>
#include <enyx/cores/namespace.hpp>

ENYX_CORES_DEFAULT_DELETE(tcp_emi_control);

ENYX_CORES_NAMESPACE_BEGIN

namespace tcp {

/**
 * @copydoc enyx_tcp_emi_control
 */
class emi_control {
public:
    /**
     * Create an EMI control object.
     *
     * @param hw_sink The hardware sink connected to the stack input EMI channel
     */
    emi_control(data_stream::sink const & hw_sink);

    /**
     * Set the TCP session @p session_id window size.
     *
     * @param session_id The ID of the TCP session to update
     * @param window_size The TCP window size to set
     * @return A result object containing an error on failure
     */
    result<void>
    set_window_size(std::uint32_t session_id, std::size_t window_size);

    /**
     * Access to the C handle.
     *
     * @return the C handle.
     */
    ::enyx_tcp_emi_control *
    handle();

    /**
     * Access to the C handle.
     *
     * @return the C handle.
     */
    ::enyx_tcp_emi_control const *
    handle() const;

private:
    std::unique_ptr<::enyx_tcp_emi_control> emi_control_;
};

}; /* namespace tcp */
ENYX_CORES_NAMESPACE_END

#include <enyx/cores/tcp/emi_control.ipp>
