ENYX_CORES_NAMESPACE_BEGIN
namespace tcp {

template<typename Handler>
inline
source::source(Handler && handler)
    : next_source_(data_stream::make_source(std::forward<Handler>(handler)))
{ }

inline void
source::operator()(std::uint8_t const * data,
                   std::uint32_t size,
                   void const * metadata)
{
    ::enyx_tcp_on_data(data, size, metadata, next_source_->handle());
}

inline ::enyx_data_stream_source
source::as_next_source() const noexcept
{
    return { next_source_->handle(), ::enyx_tcp_on_data };
}

inline result<data_stream::sink>
create_sink(data_stream::sink & data_sink)
{
    ::enyx_data_stream_sink handle{};
    if (::enyx_tcp_create_sink(&handle, data_sink.handle()))
        return std::error_code{errno, std::generic_category()};

    return data_stream::sink{handle};
}

} /* namespace tcp */
ENYX_CORES_NAMESPACE_END
