ENYX_CORES_NAMESPACE_BEGIN
namespace ethernet_flow_control {

inline
ethernet_flow_control::ethernet_flow_control(enyx::hw::core const& core)
    : core_(core),
      handle_(::enyx_ethernet_flow_control_create(core_.handle()))

{
    if (! handle_)
        throw std::system_error{errno, std::generic_category(),
                                "Failed to create ethernet flow control"};
}

inline bool
ethernet_flow_control::is_enabled() const noexcept
{
    return ::enyx_ethernet_flow_control_is_enabled(handle());
}

inline result<void>
ethernet_flow_control::enable()
{
    if (::enyx_ethernet_flow_control_enable(handle()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<void>
ethernet_flow_control::disable()
{
    if (::enyx_ethernet_flow_control_disable(handle()) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint32_t>
ethernet_flow_control::get_buffer_size() const noexcept
{
    uint32_t size;
    if (::enyx_ethernet_flow_control_get_buffer_size(handle(), &size) < 0)
        return std::error_code{errno, std::generic_category()};
    return size;
}

inline result<std::uint32_t>
ethernet_flow_control::get_internal_word_size() const noexcept
{
    uint32_t size;
    if (::enyx_ethernet_flow_control_get_internal_word_size(handle(),
                                                            &size) < 0)
        return std::error_code{errno, std::generic_category()};
    return size;
}

inline result<std::uint32_t>
ethernet_flow_control::get_used_buffer() const noexcept
{
    uint32_t size;
    if (::enyx_ethernet_flow_control_get_used_buffer(handle(), &size) < 0)
        return std::error_code{errno, std::generic_category()};
    return size;
}

inline result<std::uint32_t>
ethernet_flow_control::get_pause_threshold() const noexcept
{
    uint32_t threshold;
    if (::enyx_ethernet_flow_control_get_pause_threshold(handle(),
                                                         &threshold) < 0)
        return std::error_code{errno, std::generic_category()};
    return threshold;
}

inline result<void>
ethernet_flow_control::set_pause_threshold(std::uint32_t threshold)
{
    if (::enyx_ethernet_flow_control_set_pause_threshold(handle(),
                                                         threshold) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint32_t>
ethernet_flow_control::get_resume_threshold() const noexcept
{
    uint32_t threshold;
    if (::enyx_ethernet_flow_control_get_resume_threshold(handle(),
                                                          &threshold) < 0)
        return std::error_code{errno, std::generic_category()};
    return threshold;
}

inline result<void>
ethernet_flow_control::set_resume_threshold(std::uint32_t threshold)
{
    if (::enyx_ethernet_flow_control_set_resume_threshold(handle(),
                                                          threshold) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint32_t>
ethernet_flow_control::get_source_interface() const noexcept
{
    uint16_t interface_id;
    if (::enyx_ethernet_flow_control_get_source_interface(handle(),
                                                          &interface_id) < 0)
        return std::error_code{errno, std::generic_category()};
    return interface_id;
}

inline result<void>
ethernet_flow_control::set_source_interface(std::uint32_t interface_id)
{
    if (::enyx_ethernet_flow_control_set_source_interface(handle(),
                                                          interface_id) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint32_t>
ethernet_flow_control::get_pause_time() const noexcept
{
    uint16_t pause_time;
    if (::enyx_ethernet_flow_control_get_pause_time(handle(), &pause_time) < 0)
        return std::error_code{errno, std::generic_category()};
    return pause_time;
}

inline result<void>
ethernet_flow_control::set_pause_time(uint16_t pause_time)
{
    if (::enyx_ethernet_flow_control_set_pause_time(handle(), pause_time) < 0)
        return std::error_code{errno, std::generic_category()};
    return {};
}

inline result<std::uint32_t>
ethernet_flow_control::get_pause_frame_count() const noexcept
{
    uint32_t count;
    if (::enyx_ethernet_flow_control_get_pause_frame_count(handle(),
                                                           &count) < 0)
        return std::error_code{errno, std::generic_category()};
    return count;
}

inline ::enyx_ethernet_flow_control const *
ethernet_flow_control::handle() const noexcept
{
    return handle_.get();
}

inline ::enyx_ethernet_flow_control *
ethernet_flow_control::handle() noexcept
{
    return handle_.get();
}

} /* namespace ethernet_flow_control */
ENYX_CORES_NAMESPACE_END
